/**
 * Interrupt management for the RF
 */

#include <msp430.h>

#include <stdint.h>

#include "RF1A.h"


void packet_received(void);

// ======================================================================
/**
 * Error handling
 */

// Called if an interface error has occured. No interface errors should 
// exist in application code, so this is intended to be used for debugging
// or to catch errant operating conditions. 
static void RF1A_interface_error_handler(void)
{
  switch(RF1AIFERRV)
  {
    case 0: break;                      // No error
    case 2:                             // Low core voltage error     
//      P1OUT &= ~BIT0;					// 00 = on LED's [D2,D1]
//      P3OUT &= ~BIT6; 
      __no_operation();
      break; 
    case 4:                             // Operand Error
//      P1OUT |= BIT0;					// 01 = on LED's [D2,D1]
//      P3OUT &= ~BIT6; 
      __no_operation();
      break;  
    case 6:                             // Output data not available error 
//      P1OUT &= ~BIT0;					// 10 = on LED's [D2,D1]
//      P3OUT |= BIT6; 
      __no_operation();
      break;
    case 8:                             // Operand overwrite error
//      P1OUT |= BIT0;					// 11 = on LED's [D2,D1]
//      P3OUT |= BIT6; 
      __no_operation();
      break; 
  }
}



// If RF1A_interrupt_handler is called, an interface interrupt has occured.
static void RF1A_interrupt_handler(void)
{
  // RF1A interrupt is pending
  switch(RF1AIFIV)
  {
    case  0: break;                         // No interrupt pending
    case  2:                                // RFERRIFG 
      RF1A_interface_error_handler();
    case  4: break;                         // RFDOUTIFG
    case  6: break;                         // RFSTATIFG
    case  8: break;                         // RFDINIFG
    case 10: break;                         // RFINSTRIFG
    case 12: break;                         // RFRXIFG
    case 14: break;                         // RFTXIFG
  }
}
// ======================================================================


// ======================================================================
/** 
 * ISR
 */
#pragma vector=CC1101_VECTOR
//__interrupt void CC1101_ISR(void)
__attribute__((interrupt(CC1101_VECTOR)))
void CC1101_ISR(void)
{
  switch(RF1AIV)        // Prioritizing Radio Core Interrupts 
  {
    case  0:                                // No RF core interrupt pending 
      RF1A_interrupt_handler();             // means RF1A interface interrupt pending
      break; 
    case  2: break;                         // RFIFG0 
    case  4:          						// RFIFG1 - GD01 = LNA_PD signal
		RF1AIE &= ~(BIT1+BIT9);
		Strobe(RF_SWOR);					// Go back to sleep
		__bis_SR_register_on_exit(LPM3_bits);     
		break;                
    case  6: break;                         // RFIFG2
    case  8: break;                         // RFIFG3
    case 10:                                // RFIFG4 - RX end-of-packet
     	packet_received();
	__bic_SR_register_on_exit(LPM3_bits);     
      break;
    case 12: break;                         // RFIFG5
    case 14: break;                         // RFIFG6          
    case 16: break;                         // RFIFG7
    case 18: break;                         // RFIFG8
    case 20:                                // RFIFG9 - TX end-of-packet
	RF1AIE &= ~(BIT1+BIT9);
	__no_operation();
 	packet_received();
	__bic_SR_register_on_exit(LPM3_bits);     
      break;
    case 22: break;                         // RFIFG10
    case 24: break;                         // RFIFG11
    case 26: break;                         // RFIFG12
    case 28: break;                         // RFIFG13
    case 30:  								// RFIFG14 - WOR_EVENT0A
		P1OUT = 0x01;
		RF1AIE |= BIT9 + BIT1;
		RF1AIFG &= ~(BIT9 + BIT1);
		RF1AIES |= BIT9;					// Falling edge of RFIFG9
		RF1AIFG &= ~BIT9;					// Clear a pending interrupt
		RF1AIE |= BIT9;						// Enable the interrupt
		//Strobe(RF_SIDLE);
		//__no_operation();
		Strobe(RF_SRX);
		__no_operation();
		//while((Strobe(RF_SNOP) & 0x70) != 0x10);
		P1OUT &= ~(0x01);
		__bic_SR_register_on_exit(LPM3_bits);     
		break;                        
    case 32: break;                         // RFIFG15 - WOR_EVENT1
  }    
}


